// ObjTempParticles allows the same functionality as ObjParticles, and added:
// Removing particles from the world, fading out
/******************************************************************************/
struct ObjTempParticles : Game.ObjParticles//
{
    ObjTempParticles();
   ~ObjTempParticles();
   
   virtual void create(Object &obj);

   // update
   virtual Bool update(); // update, return false when object wants to be deleted, and true if wants to exist
   
   // Override drawing to allow fading
   virtual void drawBlend  ();
   virtual void drawPalette();
   
   void Remove() { m_Remove = true; }
   void RemoveWithFading() { m_StartRemove = true; }
   
private:
   
   bool m_Remove;
   bool m_StartRemove;
   float m_Opacity, m_Speed;
};
/******************************************************************************/
ObjTempParticles::ObjTempParticles() : m_Remove(false), m_StartRemove(false), m_Opacity(1), m_Speed(0)
{
   
}
ObjTempParticles::~ObjTempParticles()
{
   
}
/******************************************************************************/
void ObjTempParticles::create(Object &obj)
{
   if(Param* p = obj.findParam("FadeOutSpeed")) m_Speed = p.asFlt();
   
   super.create(obj);
}
/******************************************************************************/
Bool ObjTempParticles::update()
{
   // Start fading out the particles
   if(m_StartRemove)
   {
      m_Opacity -= Time.d() * m_Speed;
      
      // Particles are fully faded-out. Now remove them from the world
      if(m_Opacity <= 0) m_Remove = true;  
   }
    
   // Remove particles from the world manager
   if(m_Remove) return false;
   else return super.update();  
}
/******************************************************************************/
void ObjTempParticles::drawBlend()
{ 
   particles.draw(m_Opacity);
}
/******************************************************************************/
void ObjTempParticles::drawPalette()
{
   particles.draw(m_Opacity);
}
